package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.TextImageAdUpdate;

/**
 * Created by gerdler on 12.07.16.
 */
public class TextImageAdUpdateMap extends ImageAdUpdateBaseMap<TextImageAdUpdateMap> {
    public static final String HREF = "href";
    public static final String TURBO_PAGE_ID = "turboPageId";

    public TextImageAdUpdateMap() {
        super();
        setBean(new TextImageAdUpdate());
    }

    public TextImageAdUpdateMap(TextImageAdUpdate textImageAdUpdate) {
        super();
        setBean(textImageAdUpdate);
    }

    public TextImageAdUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextImageAdUpdateMap withHref(String href) {
        this.put(HREF, new ObjectFactory().createTextImageAdUpdateHref(href));
        return this;
    }

    public TextImageAdUpdateMap withTurbPageId(Long turboPageId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createTextImageAdUpdateTurboPageId(turboPageId);
        this.put(TURBO_PAGE_ID, jaxbElement);
        return this;
    }

}
