package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.TrackingPixelGetArray;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class TrackingPixelGetArrayMap extends ModelBeanMap<TrackingPixelGetArrayMap> {

    public static final String TRACKING_PIXEL_GET_ARRAY_ITEMS = "items";

    public TrackingPixelGetArrayMap() {
        super();
        setBean(new TrackingPixelGetArray());
    }

    public TrackingPixelGetArrayMap(TrackingPixelGetArray trackingPixelGetArray) {
        super();
        setBean(trackingPixelGetArray);
    }

    public TrackingPixelGetArrayMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TrackingPixelGetArrayMap withItems(TrackingPixelGetItemMap... items) {
        this.put(TRACKING_PIXEL_GET_ARRAY_ITEMS, (items == null) ? null : convert(items, new BeanMapToBeanConverter<>()));
        return this;
    }
}
