package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.TrackingPixelGetItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class TrackingPixelGetItemMap extends ModelBeanMap<TrackingPixelGetItemMap> {

    public static final String TRACKING_PIXEL = "trackingPixel";
    public static final String PROVIDER = "provider";

    public static final String UNKNOWN_PROVIDER = "Unknown";

    public TrackingPixelGetItemMap() {
        super();
        setBean(new TrackingPixelGetItem());
    }

    public TrackingPixelGetItemMap(TrackingPixelGetItem trackingPixelGetItem) {
        super();
        setBean(trackingPixelGetItem);
    }

    public TrackingPixelGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TrackingPixelGetItemMap withTrackingPixel(String trackingPixel) {
        this.put(TRACKING_PIXEL, trackingPixel);
        return this;
    }

    public TrackingPixelGetItemMap withProvider(String provider) {
        this.put(PROVIDER, provider);
        return this;
    }
}
