package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;

import com.yandex.direct.api.v5.ads.UpdateRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 23.03.15.
 */
public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {

    public static final String ADS = "ads";

    public UpdateRequestMap() {
        super();
        setBean(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest updateRequest) {
        super();
        setBean(updateRequest);
    }

    public UpdateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UpdateRequestMap withAds(AdUpdateItemMap... ads) {
        this.put(ADS, (ads == null) ? null : convert(ads, new BeanMapToBeanConverter()));
        return this;
    }

    public UpdateRequestMap withAds(List<AdUpdateItemMap> ads) {
        this.put(ADS, (ads == null) ? null : convert(ads, new BeanMapToBeanConverter()));
        return this;
    }
}
