package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.VideoExtensionAddItem;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 20.06.17.
 */
public class VideoExtensionAddItemMap extends ModelBeanMap<VideoExtensionAddItemMap> {
    public static final String CREATIVE_ID = "creativeId";
    public static final String GENERATE_AUTOMATICALLY = "generateAutomatically";

    public VideoExtensionAddItemMap() {
        super();
        setBean(new VideoExtensionAddItem());
    }

    public VideoExtensionAddItemMap(VideoExtensionAddItem videoExtensionAddItem) {
        super();
        setBean(videoExtensionAddItem);
    }

    public VideoExtensionAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VideoExtensionAddItemMap withCreativeId(Long creativeId) {
        this.put(CREATIVE_ID, creativeId);
        return this;
    }

    public VideoExtensionAddItemMap withGenerateAutomatically(YesNoEnum generateAutomatically) {
        this.put(GENERATE_AUTOMATICALLY, generateAutomatically);
        return this;
    }
}
