package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.VideoExtensionGetItem;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 20.06.17.
 */
public class VideoExtensionGetItemMap extends ModelBeanMap<VideoExtensionGetItemMap> {

    public static final String CREATIVE_ID = "creativeId";
    public static final String STATUS = "status";
    public static final String THUMBNAIL_URL = "thumbnailUrl";
    public static final String PREVIEW_URL = "previewUrl";

    public VideoExtensionGetItemMap() {
        super();
        setBean(new VideoExtensionGetItem());
    }

    public VideoExtensionGetItemMap(VideoExtensionGetItem videoExtensionGetItem) {
        super();
        setBean(videoExtensionGetItem);
    }

    public VideoExtensionGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VideoExtensionGetItemMap withCreativeId(Long creativeId) {
        this.put(CREATIVE_ID, creativeId);
        return this;
    }

    public VideoExtensionGetItemMap withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return this;
    }

    public VideoExtensionGetItemMap withThumbnailUrl(String thumbnailUrl) {
        this.put(THUMBNAIL_URL, thumbnailUrl);
        return this;
    }

    public VideoExtensionGetItemMap withPreviewUrl(String previewUrl) {
        this.put(PREVIEW_URL, previewUrl);
        return this;
    }
}
