package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.VideoExtensionUpdateItem;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 21.06.17.
 */
public class VideoExtensionUpdateItemMap extends ModelBeanMap<VideoExtensionUpdateItemMap> {
    public static final String CREATIVE_ID = "creativeId";
    public static final String GENERATE_AUTOMATICALLY = "generateAutomatically";

    public VideoExtensionUpdateItemMap() {
        super();
        setBean(new VideoExtensionUpdateItem());
    }

    public VideoExtensionUpdateItemMap(VideoExtensionUpdateItem videoExtensionUpdateItem) {
        super();
        setBean(videoExtensionUpdateItem);
    }

    public VideoExtensionUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VideoExtensionUpdateItemMap withCreativeId(Long creativeId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createVideoExtensionUpdateItemCreativeId(creativeId);
        this.put(CREATIVE_ID, jaxbElement);
        return this;
    }

    public VideoExtensionUpdateItemMap withGenerateAutomatically(YesNoEnum generateAutomatically) {
        this.put(GENERATE_AUTOMATICALLY, generateAutomatically);
        return this;
    }
}
