package ru.yandex.autotests.directapi.model.api5.agencyclients;

import java.util.ArrayList;
import java.util.List;

import com.yandex.direct.api.v5.agencyclients.AddRequest;
import com.yandex.direct.api.v5.general.CurrencyEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingAddEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingAddItem;
import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientSettingAddItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.GrantItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.NotificationAddMap;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


public class AddRequestMap extends ModelBeanMap<AddRequestMap> {
    public static final String LOGIN = "login";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String CURRENCY = "currency";
    public static final String NOTIFICATION = "notification";
    public static final String SETTINGS = "settings";
    public static final String GRANTS = "grants";
    public static final int MAX_LOGIN_LENGTH = 30;
    public static final CurrencyEnum DEFAULT_CURRENCY = CurrencyEnum.RUB;
    public static final String DEFAULT_FIRST_NAME = "aaa";
    public static final String DEFAULT_LAST_NAME = "bbbb";

    public AddRequestMap() {
        this(new AddRequest());
    }

    public AddRequestMap(AddRequest request) {
        super();
        setBean(request);
    }

    public AddRequestMap withLogin(String login) {
        return put(LOGIN, login);
    }

    public AddRequestMap withRandomLogin(String loginBase) {
        return withLogin(generateLogin(loginBase));
    }

    public AddRequestMap withFirstName(String firstName) {
        return put(FIRST_NAME, firstName);
    }

    public AddRequestMap withLastName(String lastName) {
        return put(LAST_NAME, lastName);
    }

    public AddRequestMap withCurrency(CurrencyEnum currency) {
        return put(CURRENCY, currency);
    }

    public AddRequestMap withNotification(NotificationAddMap notification) {
        return putBeanMap(NOTIFICATION, notification);
    }

    public AddRequestMap withSettings(ClientSettingAddItemMap... settings) {
        return putBeanMapList(SETTINGS, settings);
    }

    public AddRequestMap withGrants(GrantItemMap... grants) {
        return putBeanMapList(GRANTS, grants);
    }

    public AddRequestMap withDefault(String login) {
        withLogin(login);
        withCurrency(DEFAULT_CURRENCY);
        withFirstName(DEFAULT_FIRST_NAME);
        withLastName(DEFAULT_LAST_NAME);
        withNotification(new NotificationAddMap().withDefault());
        return this;
    }

    @SuppressWarnings("unchecked")
    public AddRequestMap withoutSharedAccount() {
        List<ClientSettingAddItem> oldSettings = (List<ClientSettingAddItem>)this.get(SETTINGS);
        ArrayList<ClientSettingAddItemMap> newSettings = new ArrayList<>();
        oldSettings.forEach(s -> newSettings.add(new ClientSettingAddItemMap(s)));
        newSettings.add(new ClientSettingAddItemMap(ClientSettingAddEnum.SHARED_ACCOUNT_ENABLED, YesNoEnum.NO));
        return this.withSettings(newSettings.toArray(new ClientSettingAddItemMap[0]));
    }

    public static String generateLogin(String loginBase) {
        return loginBase + RandomStringUtils.randomAlphabetic(MAX_LOGIN_LENGTH - loginBase.length());
    }
}
