package ru.yandex.autotests.directapi.model.api5.agencyclients;

import com.yandex.direct.api.v5.agencyclients.AgencyClientUpdateItem;

import ru.yandex.autotests.directapi.model.api5.clients.ClientUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.GrantItemMap;

public class AgencyClientUpdateItemMap extends ClientUpdateItemMap<AgencyClientUpdateItemMap> {
    public static final String CLIENT_ID = "clientId";
    private static final String GRANTS = "grants";

    public AgencyClientUpdateItemMap() {
        this(new AgencyClientUpdateItem());
    }

    public AgencyClientUpdateItemMap(AgencyClientUpdateItem updateItem) {
        super();
        setBean(updateItem);
    }

    public AgencyClientUpdateItemMap withClientId(Long clientId) {
        return put(CLIENT_ID, clientId);
    }

    public AgencyClientUpdateItemMap withGrants(GrantItemMap... grants) {
        return putBeanMapList(GRANTS, grants);
    }
}
