package ru.yandex.autotests.directapi.model.api5.agencyclients;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.agencyclients.AgencyClientsSelectionCriteria;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AgencyClientsSelectionCriteriaMap extends ModelBeanMap<AgencyClientsSelectionCriteriaMap> {
    public static final String LOGINS = "logins";
    public static final String ARCHIVED = "archived";

    public static final Integer LOGINS_MAX_SIZE = 10000;

    public AgencyClientsSelectionCriteriaMap() {
        super();
        setBean(new AgencyClientsSelectionCriteria());
    }

    public AgencyClientsSelectionCriteriaMap(AgencyClientsSelectionCriteria agencyClientsSelectionCriteria) {
        super();
        setBean(agencyClientsSelectionCriteria);
    }

    public AgencyClientsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AgencyClientsSelectionCriteriaMap withLogins(String... logins) {
        this.put(LOGINS, Arrays.asList(logins));
        return this;
    }

    public AgencyClientsSelectionCriteriaMap withLogins(List<String> logins) {
        this.put(LOGINS, logins);
        return this;
    }

    public AgencyClientsSelectionCriteriaMap withArchived(YesNoEnum archived) {
        this.put(ARCHIVED, archived);
        return this;
    }
}
