package ru.yandex.autotests.directapi.model.api5.agencyclients;

import java.util.Arrays;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.AgencyClientsSelectionCriteria;
import com.yandex.direct.api.v5.agencyclients.GetRequest;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {
    public static final String FIELD_NAMES = "fieldNames";
    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public GetRequestMap() {
        this(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap withFieldNames(AgencyClientFieldEnum... fieldNames) {
        return put(FIELD_NAMES, Arrays.asList(fieldNames));
    }

    public GetRequestMap withAllFieldNames() {
        return put(FIELD_NAMES, Arrays.asList(AgencyClientFieldEnum.class.getEnumConstants()));
    }

    public GetRequestMap withSelectionCriteria(AgencyClientsSelectionCriteriaMap selectionCriteria) {
        return putBeanMap(SELECTION_CRITERIA, selectionCriteria);
    }

    public GetRequestMap withSelectionCriteria(AgencyClientsSelectionCriteria agencyClientsSelectionCriteria) {
        return put(SELECTION_CRITERIA, agencyClientsSelectionCriteria);
    }

    public GetRequestMap withSubclientLogins(String... logins) {
        AgencyClientsSelectionCriteria agencyClientsSelectionCriteria = new AgencyClientsSelectionCriteria();
        agencyClientsSelectionCriteria.setLogins(Arrays.asList(logins));

        return withSelectionCriteria(agencyClientsSelectionCriteria);
    }
}
