package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String AUDIENCE_TARGETS = "audienceTargets";
    public static final Integer MAX_AMOUNT_AUDIENCE_TARGETS_IN_ONE_REQUEST = 1000;
    public static final Integer MAX_RET_COND_PER_CPM_BANNER_AD_GROUP = 1;

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withAudienceTargets(AudienceTargetAddItemMap... addItems) {
        this.put(AUDIENCE_TARGETS, (addItems == null) ? null : convert(addItems, new BeanMapToBeanConverter()));
        return this;
    }
}
