package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetAddItem;

public class AudienceTargetAddItemMap extends AudienceTargetBaseMap<AudienceTargetAddItemMap> {

    public static final String AD_GROUP_ID = "adGroupId";
    public static final String RETARGETING_LIST_ID = "retargetingListId";
    public static final String INTEREST_ID = "interestId";

    public AudienceTargetAddItemMap() {
        super();
        setBean(new AudienceTargetAddItem());
    }

    public AudienceTargetAddItemMap(AudienceTargetAddItem audienceTargetAddItem) {
        super();
        setBean(audienceTargetAddItem);
    }

    public AudienceTargetAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AudienceTargetAddItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public AudienceTargetAddItemMap withRetargetingListId(Long retargetingListId) {
        this.put(RETARGETING_LIST_ID, retargetingListId);
        return this;
    }

    public AudienceTargetAddItemMap withInterestId(Long interestId) {
        this.put(INTEREST_ID, interestId);
        return this;
    }


}
