package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.general.PriorityEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AudienceTargetBaseMap<T> extends ModelBeanMap<AudienceTargetBaseMap> {

    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";

    public AudienceTargetBaseMap() {
        super();
    }

    public T withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return (T) this;
    }

    public T withStrategyPriority(PriorityEnum strategyPriority) {
        this.put(STRATEGY_PRIORITY, strategyPriority);
        return (T) this;
    }
}
