package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.audiencetargets.ObjectFactory;
import com.yandex.direct.api.v5.general.StateEnum;

public class AudienceTargetGetItemMap extends AudienceTargetBaseMap<AudienceTargetGetItemMap> {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public static final String STATE = "state";
    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String RETARGETING_LIST_ID = "retargetingListId";
    public static final String INTEREST_ID = "interestId";

    public AudienceTargetGetItemMap() {
        super();
        setBean(new AudienceTargetGetItem());
    }

    public AudienceTargetGetItemMap(AudienceTargetGetItem audienceTargetGetItem) {
        super();
        setBean(audienceTargetGetItem);
    }

    public AudienceTargetGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AudienceTargetGetItemMap withState(StateEnum state) {
        this.put(STATE, state);
        return this;
    }

    public AudienceTargetGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public AudienceTargetGetItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public AudienceTargetGetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public AudienceTargetGetItemMap withInterestId(Long interestId) {
        this.put(INTEREST_ID, OBJECT_FACTORY.createAudienceTargetGetItemInterestId(interestId));
        return this;
    }

    public AudienceTargetGetItemMap withRetargetingListId(Long retargetingListId) {
        this.put(RETARGETING_LIST_ID, OBJECT_FACTORY.createAudienceTargetGetItemRetargetingListId(retargetingListId));
        return this;
    }
}

