package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetSelectionCriteria;
import com.yandex.direct.api.v5.general.StateEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AudienceTargetSelectionCriteriaMap extends ModelBeanMap<AudienceTargetSelectionCriteriaMap> {

    public static final String IDS = "ids";
    public static final String AD_GROUP_IDS = "adGroupIds";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String STATES = "states";
    public static final String RETARGETING_LISTS_IDS = "retargetingListIds";
    public static final String INTEREST_IDS = "interestIds";
    public static final Integer MAX_AMOUNT_OF_IDS = 10000;
    public static final Integer MAX_AMOUNT_OF_CAMPAIGN_IDS = 100;
    public static final Integer MAX_AMOUNT_OF_AD_GROUP_IDS = 1000;
    public static final Integer MAX_AMOUNT_OF_RETARGETING_LISTS_IDS = 1000;
    public static final Integer MAX_AMOUNT_OF_INTEREST_IDS = 1000;

    public AudienceTargetSelectionCriteriaMap() {
        super();
        setBean(new AudienceTargetSelectionCriteria());
    }

    public AudienceTargetSelectionCriteriaMap(AudienceTargetSelectionCriteria audienceTargetSelectionCriteria) {
        super();
        setBean(audienceTargetSelectionCriteria);
    }

    public AudienceTargetSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AudienceTargetSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }


    public AudienceTargetSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(AD_GROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public AudienceTargetSelectionCriteriaMap withCampaignIds(Long... сampaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(сampaignIds));
        return this;
    }

    public AudienceTargetSelectionCriteriaMap withRetargetingListsIds(Long... retargetingListsIds) {
        this.put(RETARGETING_LISTS_IDS, Arrays.asList(retargetingListsIds));
        return this;
    }

    public AudienceTargetSelectionCriteriaMap withInterestIds(Long... interestIds) {
        this.put(INTEREST_IDS, Arrays.asList(interestIds));
        return this;
    }

    public AudienceTargetSelectionCriteriaMap withStates(StateEnum... states) {
        this.put(STATES, Arrays.asList(states));
        return this;
    }

}

