package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.DeleteRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

public class DeleteRequestMap extends ModelBeanMap<DeleteRequestMap> {
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final Integer MAX_AMOUNT_OF_IDS_IN_DELETE_REQUEST = 10000;

    public DeleteRequestMap() {
        super();
        setBean(new DeleteRequest());
    }

    public DeleteRequestMap(DeleteRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public DeleteRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DeleteRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
