package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(AudienceTargetSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(AudienceTargetFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFullFieldNames() {
        this.put(FIELD_NAMES, Arrays.asList(
                AudienceTargetFieldEnum.values()
        ));
        return this;
    }
}
