package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.ResumeRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

public class ResumeRequestMap extends ModelBeanMap<ResumeRequestMap> {
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final Integer MAX_AMOUNT_OF_IDS_IN_RESUME_REQUEST = 10000;

    public ResumeRequestMap() {
        super();
        setBean(new ResumeRequest());
    }

    public ResumeRequestMap(ResumeRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public ResumeRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ResumeRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
