package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.SetBidsRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class SetBidsRequestMap extends ModelBeanMap<SetBidsRequestMap> {

    public static final String BIDS = "bids";
    public static final Integer MAX_AMOUNT_OF_BIDS_WITH_ID = 10000;
    public static final Integer MAX_AMOUNT_OF_BIDS_WITH_AD_GROUP_ID = 1000;
    public static final Integer MAX_AMOUNT_OF_BIDS_WITH_CAMPAIGN_ID = 100;

    public SetBidsRequestMap() {
        super();
        setBean(new SetBidsRequest());
    }

    public SetBidsRequestMap(SetBidsRequest setBidsRequest) {
        super();
        setBean(setBidsRequest);
    }

    public SetBidsRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SetBidsRequestMap withBids(AudienceTargetSetBidsItemMap... bids) {
        this.put(BIDS, (bids == null) ? null : convert(bids, new BeanMapToBeanConverter()));
        return this;
    }
}
