package ru.yandex.autotests.directapi.model.api5.audiencetargets;

import com.yandex.direct.api.v5.audiencetargets.SuspendRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

public class SuspendRequestMap extends ModelBeanMap<SuspendRequestMap> {
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final Integer MAX_AMOUNT_OF_IDS_IN_SUSPEND_REQUEST = 10000;

    public SuspendRequestMap() {
        super();
        setBean(new SuspendRequest());
    }

    public SuspendRequestMap(SuspendRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public SuspendRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SuspendRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
