package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 13.07.15.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String BID_MODIFIERS = "bidModifiers";

    public static final int BID_MODIFIERS_IN_REQUEST_LIMIT = 1000;

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withBidModifiers(BidModifierAddMap... bidModifiers) {
        this.put(BID_MODIFIERS, (bidModifiers == null) ? null : convert(bidModifiers, new BeanMapToBeanConverter()));
        return this;
    }
}
