package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierAddItem;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 13.07.15.
 */
public class BidModifierAddMap extends ModelBeanMap<BidModifierAddMap> {
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String ADGROUP_ID = "adGroupId";
    public static final String MOBILE_ADJUSTMENT = "mobileAdjustment";
    public static final String DESKTOP_ADJUSTMENT = "desktopAdjustment";
    public static final String DEMOGRAPHICS_ADJUSTMENT = "demographicsAdjustments";
    public static final String RETARGETING_ADJUSTMENT = "retargetingAdjustments";
    public static final String REGIONAL_ADJUSTMENT = "regionalAdjustments";
    public static final String SMART_ADJUSTMENT = "smartAdAdjustment";
    public static final String VIDEO_ADJUSTMENT = "videoAdjustment";
    public static final String SERP_LAYOUT_ADJUSTMENT = "serpLayoutAdjustments";
    public static final String INCOME_GRADE_ADJUSTMENT = "incomeGradeAdjustments";
    public static final String SMART_TV_ADJUSTMENT = "smartTvAdjustment";
    public static final String TABLET_ADJUSTMENT = "tabletAdjustment";
    public static final String DESKTOP_ONLY_ADJUSTMENT = "desktopOnlyAdjustment";

    public static final int DEFAULT_BID_MODIFIER = 110;

    public static final int DEMOGRAPHICS_ADJUSTMENT_IN_REQUEST_LIMIT = 12;
    public static final int RETARGETING_ADJUSTMENT_IN_REQUEST_LIMIT = 100;
    public static final int COMMON_LIMIT_IN_ONE_REQUEST = 1000;
    public static final int SERP_LAYOUT_ADJUSTMENT_IN_REQUEST_LIMIT = 2;

    public BidModifierAddMap() {
        this(new BidModifierAddItem());
    }

    public BidModifierAddMap(BidModifierAddItem bidModifier) {
        super();
        setBean(bidModifier);
    }

    public BidModifierAddMap defaultBidModifier() {
        this.clear();
        return this.withDemographicsAdjustment(new DemographicsAdjustmentMap().defaultDemographicsAdjustment());
    }

    public BidModifierAddMap withCampaignId(Long campaignId) {
        return put(CAMPAIGN_ID, campaignId);
    }

    public BidModifierAddMap withAdGroupId(Long adGroupId) {
        return put(ADGROUP_ID, adGroupId);
    }

    public BidModifierAddMap withMobileAdjustment(MobileAdjustmentMap mobileAdjustment) {
        return putBeanMap(MOBILE_ADJUSTMENT, mobileAdjustment);
    }

    public BidModifierAddMap withDesktopAdjustment(DesktopAdjustmentMap desktopAdjustmentMap) {
        return putBeanMap(DESKTOP_ADJUSTMENT, desktopAdjustmentMap);
    }

    public BidModifierAddMap withSmartTvAdjustment(SmartTvAdjustmentMap smartTvAdjustmentMap) {
        return putBeanMap(SMART_TV_ADJUSTMENT, smartTvAdjustmentMap);
    }

    public BidModifierAddMap withVideoAdjustment(VideoAdjustmentMap videoAdjustment) {
        this.put(VIDEO_ADJUSTMENT, (videoAdjustment == null) ? null : videoAdjustment.getBean());
        return this;
    }

    public BidModifierAddMap withDemographicsAdjustment(DemographicsAdjustmentMap... demographicsAdjustments) {
        this.put(DEMOGRAPHICS_ADJUSTMENT, (demographicsAdjustments == null) ? null
                : convert(demographicsAdjustments, new BeanMapToBeanConverter()));
        return this;
    }

    public BidModifierAddMap withRetargetingAdjustment(RetargetingAdjustmentMap... retargetingAdjustments) {
        this.put(RETARGETING_ADJUSTMENT, (retargetingAdjustments == null) ? null
                : convert(retargetingAdjustments, new BeanMapToBeanConverter()));
        return this;
    }

    public BidModifierAddMap withRegionalAdjustment(RegionalAdjustmentMap... regionalAdjustments) {
        this.put(REGIONAL_ADJUSTMENT,
                (regionalAdjustments == null) ? null : convert(regionalAdjustments, new BeanMapToBeanConverter()));
        return this;
    }

    public BidModifierAddMap withSerpLayoutAdjustment(SerpLayoutAdjustmentMap... serpLayoutAdjustments) {
        this.put(SERP_LAYOUT_ADJUSTMENT, (serpLayoutAdjustments == null) ? null
                : convert(serpLayoutAdjustments, new BeanMapToBeanConverter()));
        return this;
    }

    public BidModifierAddMap withIncomeGradeAdjustments(IncomeGradeAdjustmentMap... incomeGradeAdjustments) {
        this.put(INCOME_GRADE_ADJUSTMENT,
                (incomeGradeAdjustments == null) ? null : convert(incomeGradeAdjustments,
                        new BeanMapToBeanConverter()));
        return this;
    }


    public static String getBidModifiersMandatoryIdNames() {
        return new StringBuilder()
                .append(StringUtils.capitalize(CAMPAIGN_ID))
                .append(", ")
                .append(StringUtils.capitalize(ADGROUP_ID))
                .toString();
    }

    public static String getBidModifiersMandatoryAdjustmentNames() {
        return new StringBuilder()
                .append(StringUtils.capitalize(MOBILE_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(DEMOGRAPHICS_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(RETARGETING_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(REGIONAL_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(VIDEO_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(DESKTOP_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(SMART_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(SERP_LAYOUT_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(INCOME_GRADE_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(SMART_TV_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(TABLET_ADJUSTMENT))
                .append(", ")
                .append(StringUtils.capitalize(DESKTOP_ONLY_ADJUSTMENT))
                .toString();
    }
}
