package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 14.07.15.
 */
public class BidModifierGetItemMap extends ModelBeanMap<BidModifierGetItemMap> {

    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String ADGROUP_ID = "adGroupId";
    public static final String LEVEL = "level";
    public static final String TYPE = "type";
    public static final String MOBILE_ADJUSTMENT = "mobileAdjustment";
    public static final String DEMOGRAPHICS_ADJUSTMENT = "demographicsAdjustment";
    public static final String RETARGETING_ADJUSTMENT = "retargetingAdjustment";
    public static final String REGIONAL_ADJUSTMENT = "regionalAdjustment";
    public static final String VIDEO_ADJUSTMENT = "videoAdjustment";
    public static final String SERP_LAYOUT_ADJUSTMENT = "serpLayoutAdjustment";
    public static final String INCOME_GRADE_ADJUSTMENT = "incomeGradeAdjustment";

    public BidModifierGetItemMap() {
        super();
        setBean(new BidModifierGetItem());
    }

    public BidModifierGetItemMap(BidModifierGetItem bidModifier) {
        super();
        setBean(bidModifier);
    }

    public BidModifierGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidModifierGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public BidModifierGetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public BidModifierGetItemMap withAdGroupId(Long adGroupId) {
        this.put(ADGROUP_ID, adGroupId);
        return this;
    }

    public BidModifierGetItemMap withLevel(BidModifierLevelEnum level) {
        this.put(LEVEL, level);
        return this;
    }

    public BidModifierGetItemMap withType(BidModifierTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public BidModifierGetItemMap withMobileAdjustment(MobileAdjustmentGetMap mobileAdjustment) {
        this.put(MOBILE_ADJUSTMENT, (mobileAdjustment == null) ? null : mobileAdjustment.getBean());
        return this;
    }

    public BidModifierGetItemMap withVideoAdjustment(VideoAdjustmentGetMap videoAdjustment) {
        this.put(VIDEO_ADJUSTMENT, (videoAdjustment == null) ? null : videoAdjustment.getBean());
        return this;
    }

    public BidModifierGetItemMap withDemographicsAdjustment(DemographicsAdjustmentGetMap demographicsAdjustment) {
        this.put(DEMOGRAPHICS_ADJUSTMENT, (demographicsAdjustment == null) ? null : demographicsAdjustment.getBean());
        return this;
    }

    public BidModifierGetItemMap withRetargetingAdjustment(RetargetingAdjustmentGetMap retargetingAdjustment) {
        this.put(RETARGETING_ADJUSTMENT, (retargetingAdjustment == null) ? null : retargetingAdjustment.getBean());
        return this;
    }

    public BidModifierGetItemMap withRegionalAdjustment(RegionalAdjustmentGetMap regionalAdjustment) {
        this.put(REGIONAL_ADJUSTMENT, (regionalAdjustment == null) ? null : regionalAdjustment.getBean());
        return this;
    }

    public BidModifierGetItemMap withSerpLayoutAdjustment(SerpLayoutAdjustmentGetMap serpLayoutAdjustment) {
        this.put(SERP_LAYOUT_ADJUSTMENT, (serpLayoutAdjustment == null) ? null : serpLayoutAdjustment.getBean());
        return this;
    }

    public BidModifierGetItemMap withIncomeGradeAdjustment(IncomeGradeAdjustmentGetMap incomeGradeAdjustment) {
        this.put(INCOME_GRADE_ADJUSTMENT, (incomeGradeAdjustment == null) ? null : incomeGradeAdjustment.getBean());
        return this;
    }
}
