package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierSetItem;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 31.07.15.
 */
public class BidModifierSetMap extends ModelBeanMap<BidModifierSetMap> {

    public static final String ID = "id";
    public static final String BID_MODIFIER = "bidModifier";

    public static final int DEFAULT_BID_MODIFIER = 112;

    public BidModifierSetMap() {
        super();
        setBean(new BidModifierSetItem());
    }

    public BidModifierSetMap(BidModifierSetItem bidModifier) {
        super();
        setBean(bidModifier);
    }

    public BidModifierSetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidModifierSetMap defaultBidModifier() {
        this.clear();
        return this.withBidModifier(DEFAULT_BID_MODIFIER);
    }

    public BidModifierSetMap withId(Long bmId) {
        this.put(ID, bmId);
        return this;
    }

    public BidModifierSetMap withBidModifier(Integer bmValue) {
        this.put(BID_MODIFIER, bmValue);
        return this;
    }

    public static String getBidModifiersMandatoryIdNames() {
        return new StringBuilder()
                .append(StringUtils.capitalize(ID))
                .append(", ")
                .append(StringUtils.capitalize(BID_MODIFIER))
                .toString();
    }
}
