package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 31.07.15.
 */
public class BidModifierToggleMap extends ModelBeanMap<BidModifierToggleMap> {

    public static final String CAMPAIGN_ID = "campaignId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String TYPE = "type";
    public static final String ENABLED = "enabled";

    public BidModifierToggleMap() {
        super();
        setBean(new BidModifierToggleItem());
    }

    public BidModifierToggleMap(BidModifierToggleItem bidModifier) {
        super();
        setBean(bidModifier);
    }

    public BidModifierToggleMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidModifierToggleMap defaultBidModifier() {
        this.clear();
        return this.withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                .withEnabled(YesNoEnum.NO);
    }

    public BidModifierToggleMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public BidModifierToggleMap withAdGroupId(Long groupdId) {
        this.put(AD_GROUP_ID, groupdId);
        return this;
    }

    public BidModifierToggleMap withType(BidModifierToggleTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public BidModifierToggleMap withEnabled(YesNoEnum value) {
        this.put(ENABLED, value);
        return this;
    }

    public BidModifierToggleMap withType(String type) {
        this.put(TYPE, type);
        return this;
    }

    public BidModifierToggleMap withEnabled(String value) {
        this.put(ENABLED, value);
        return this;
    }

    public static String getBidModifiersMandatoryIdNames() {
        return new StringBuilder()
                .append(StringUtils.capitalize(CAMPAIGN_ID))
                .append(", ")
                .append(StringUtils.capitalize(AD_GROUP_ID))
                .toString();
    }
}
