package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import java.util.Arrays;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierTypeEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifiersSelectionCriteria;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 13.07.15.
 */
public class BidModifiersSelectionCriteriaMap extends ModelBeanMap<BidModifiersSelectionCriteriaMap> {
    public static final String IDS = "ids";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String LEVELS = "levels";
    public static final String TYPES = "types";

    public static final int IDS_MAX_LENGTH = 10000;
    public static final int ADGROUP_IDS_MAX_LENGTH = 10000;
    public static final int CAMPAIGN_IDS__MAX_LENGTH = 1000;

    public BidModifiersSelectionCriteriaMap() {
        super();
        setBean(new BidModifiersSelectionCriteria());
    }

    public BidModifiersSelectionCriteriaMap(BidModifiersSelectionCriteria selectionCriteria) {
        super();
        setBean(selectionCriteria);
    }

    public BidModifiersSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, (ids == null) ? null : Arrays.asList(ids));
        return this;
    }

    public BidModifiersSelectionCriteriaMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, (campaignIds == null) ? null : Arrays.asList(campaignIds));
        return this;
    }

    public BidModifiersSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, (adGroupIds == null) ? null : Arrays.asList(adGroupIds));
        return this;
    }

    public BidModifiersSelectionCriteriaMap withLevels(BidModifierLevelEnum... levels) {
        this.put(LEVELS, (levels == null) ? null : Arrays.asList(levels));
        return this;
    }

    public BidModifiersSelectionCriteriaMap withTypes(BidModifierTypeEnum... types) {
        this.put(TYPES, (types == null) ? null : Arrays.asList(types));
        return this;
    }

    public BidModifiersSelectionCriteriaMap withAllLevels() {
        this.put(LEVELS, Arrays.asList(BidModifierLevelEnum.class.getEnumConstants()));
        return this;
    }

    public BidModifiersSelectionCriteriaMap withAllTypes() {
        this.put(TYPES, Arrays.asList(BidModifierTypeEnum.class.getEnumConstants()));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public BidModifiersSelectionCriteriaMap withTypes(String... types) {
        this.put(TYPES, (types == null) ? null : Arrays.asList(types));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public BidModifiersSelectionCriteriaMap withLevels(String... levels) {
        this.put(LEVELS, (levels == null) ? null : Arrays.asList(levels));
        return this;
    }

    public static String getRequiredIdNames() {
        return new StringBuilder()
                .append(StringUtils.capitalize(CAMPAIGN_IDS))
                .append(", ")
                .append(StringUtils.capitalize(ADGROUP_IDS))
                .append(", ")
                .append(StringUtils.capitalize(IDS))
                .toString();
    }
}
