package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentAdd;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentGet;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 05.11.15.
 */
public class DemographicsAdjustmentGetMap extends ModelBeanMap<DemographicsAdjustmentGetMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String AGE = "age";
    public static final String GENDER = "gender";

    public DemographicsAdjustmentGetMap() {
        super();
        setBean(new DemographicsAdjustmentGet());
    }

    public DemographicsAdjustmentGetMap(DemographicsAdjustmentAdd demographicsAdjustment) {
        super();
        setBean(demographicsAdjustment);
    }

    public DemographicsAdjustmentGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DemographicsAdjustmentGetMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public DemographicsAdjustmentGetMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public DemographicsAdjustmentGetMap withAge(AgeRangeEnum age) {
        this.put(AGE, age);
        return this;
    }

    public DemographicsAdjustmentGetMap withGender(GenderEnum gender) {
        this.put(GENDER, gender);
        return this;
    }

    /**
     * For negative cases usage
     */
    public DemographicsAdjustmentGetMap withAge(String age) {
        this.put(AGE, age);
        return this;
    }

    /**
     * For negative cases usage
     */
    public DemographicsAdjustmentGetMap withGender(String gender) {
        this.put(GENDER, gender);
        return this;
    }
}
