package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentAdd;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 13.07.15.
 */
public class DemographicsAdjustmentMap extends ModelBeanMap<DemographicsAdjustmentMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String AGE = "age";
    public static final String GENDER = "gender";

    public static final int DEMOGRAPHICS_ADJUSTMENT_MAX = 1300;
    public static final int DEMOGRAPHICS_ADJUSTMENT_MIN = 0;

    public DemographicsAdjustmentMap() {
        super();
        setBean(new DemographicsAdjustmentAdd());
    }

    public DemographicsAdjustmentMap(DemographicsAdjustmentAdd demographicsAdjustment) {
        super();
        setBean(demographicsAdjustment);
    }

    public DemographicsAdjustmentMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DemographicsAdjustmentMap defaultDemographicsAdjustment() {
        this.clear();
        return this.withGender(GenderEnum.GENDER_MALE)
                .withAge(AgeRangeEnum.AGE_18_24)
                .withDefaultBidModifier();
    }

    public DemographicsAdjustmentMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public DemographicsAdjustmentMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public DemographicsAdjustmentMap withAge(AgeRangeEnum age) {
        this.put(AGE, age);
        return this;
    }

    public DemographicsAdjustmentMap withGender(GenderEnum gender) {
        this.put(GENDER, gender);
        return this;
    }

    /**
     * For negative cases usage
     */
    public DemographicsAdjustmentMap withAge(String age) {
        this.put(AGE, age);
        return this;
    }

    /**
     * For negative cases usage
     */
    public DemographicsAdjustmentMap withGender(String gender) {
        this.put(GENDER, gender);
        return this;
    }

}
