package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.DesktopAdjustmentGet;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


public class DesktopAdjustmentGetMap extends ModelBeanMap<DesktopAdjustmentGetMap> {
    public static final String BID_MODIFIER = "bidModifier";

    public DesktopAdjustmentGetMap() {
        this(new DesktopAdjustmentGet());
    }

    public DesktopAdjustmentGetMap(DesktopAdjustmentGet desktopAdjustment) {
        super();
        setBean(desktopAdjustment);
    }

    public DesktopAdjustmentGetMap defaultDesktopAdjustment() {
        this.clear();
        return withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public DesktopAdjustmentGetMap withBidModifier(Integer bidModifier) {
        return put(BID_MODIFIER, bidModifier);
    }
}
