package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.DesktopAdjustmentAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


public class DesktopAdjustmentMap extends ModelBeanMap<DesktopAdjustmentMap> {
    public static final String BID_MODIFIER = "bidModifier";

    public static final int DESKTOP_ADJUSTMENT_MAX = 1300;
    public static final int DESKTOP_ADJUSTMENT_MIN = 50;
    public static final int DESKTOP_ADJUSTMENT_ABSOLUTE_MIN = 0;

    public DesktopAdjustmentMap() {
        this(new DesktopAdjustmentAdd());
    }

    public DesktopAdjustmentMap(DesktopAdjustmentAdd desktopAdjustment) {
        super();
        setBean(desktopAdjustment);
    }

    public DesktopAdjustmentMap defaultDesktopAdjustment() {
        this.clear();
        return withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public DesktopAdjustmentMap withBidModifier(Integer bidModifier) {
        return put(BID_MODIFIER, bidModifier);
    }
}
