package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import java.util.Arrays;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DesktopAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.GetRequest;
import com.yandex.direct.api.v5.bidmodifiers.IncomeGradeAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.RegionalAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.RetargetingAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.SerpLayoutAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.SmartTvAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.VideoAdjustmentFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by chicos on 14.07.15.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String DEMOGRAPHICS_FIELD_NAMES = "demographicsAdjustmentFieldNames";
    public static final String RETARGETING_FIELD_NAMES = "retargetingAdjustmentFieldNames";
    public static final String REGIONAL_FIELD_NAMES = "regionalAdjustmentFieldNames";
    public static final String MOBILE_FIELD_NAMES = "mobileAdjustmentFieldNames";
    public static final String DESKTOP_FIELD_NAMES = "desktopAdjustmentFieldNames";
    public static final String SMARTTV_FIELD_NAMES = "smartTvAdjustmentFieldNames";
    public static final String VIDEO_FIELD_NAMES = "videoAdjustmentFieldNames";
    public static final String SERP_LAYOUT_FIELD_NAMES = "serpLayoutAdjustmentFieldNames";
    public static final String INCOME_GRADE_NAMES = "incomeGradeAdjustmentFieldNames";


    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(BidModifiersSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(BidModifierFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withMobileFieldNames(MobileAdjustmentFieldEnum... fieldNames) {
        this.put(MOBILE_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDesktopFieldNames(DesktopAdjustmentFieldEnum... fieldNames) {
        this.put(DESKTOP_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withSmartTvFieldNames(SmartTvAdjustmentFieldEnum... fieldNames) {
        this.put(SMARTTV_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withVideoFieldNames(VideoAdjustmentFieldEnum... fieldNames) {
        this.put(VIDEO_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDemographicsFieldNames(DemographicsAdjustmentFieldEnum... fieldNames) {
        this.put(DEMOGRAPHICS_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withRetargetingFieldNames(RetargetingAdjustmentFieldEnum... fieldNames) {
        this.put(RETARGETING_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withRegionalFieldNames(RegionalAdjustmentFieldEnum... fieldNames) {
        this.put(REGIONAL_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withSerpLayoutFieldNames(SerpLayoutAdjustmentFieldEnum... fieldNames) {
        this.put(SERP_LAYOUT_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllFieldNames() {
        this.put(FIELD_NAMES, Arrays.asList(BidModifierFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withAllMobileFieldNames() {
        this.put(MOBILE_FIELD_NAMES, Arrays.asList(MobileAdjustmentFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withAllVideoFieldNames() {
        this.put(VIDEO_FIELD_NAMES, Arrays.asList(VideoAdjustmentFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withAllDemographicsFieldNames() {
        this.put(DEMOGRAPHICS_FIELD_NAMES, Arrays.asList(DemographicsAdjustmentFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withAllRetargetingFieldNames() {
        this.put(RETARGETING_FIELD_NAMES, Arrays.asList(RetargetingAdjustmentFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withAllRegionalFieldNames() {
        this.put(REGIONAL_FIELD_NAMES, Arrays.asList(RegionalAdjustmentFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withAllIncomeGradeFieldNames() {
        this.put(INCOME_GRADE_NAMES, Arrays.asList(IncomeGradeAdjustmentFieldEnum.values()));
        return this;
    }

    public GetRequestMap withIncomeGradeFieldNames(IncomeGradeAdjustmentFieldEnum... fieldNames) {
        this.put(INCOME_GRADE_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllSerpLayoutFieldNames() {
        this.put(SERP_LAYOUT_FIELD_NAMES, Arrays.asList(SerpLayoutAdjustmentFieldEnum.class.getEnumConstants()));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withMobileFieldNames(String... fieldNames) {
        this.put(MOBILE_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withVideoFieldNames(String... fieldNames) {
        this.put(VIDEO_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withDemographicsFieldNames(String... fieldNames) {
        this.put(DEMOGRAPHICS_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withRetargetingFieldNames(String... fieldNames) {
        this.put(RETARGETING_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withRegionalFieldNames(String... fieldNames) {
        this.put(REGIONAL_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    /**
     * Used for negative tests to pass invalid values
     */
    public GetRequestMap withSerpLayoutFieldNames(String... fieldNames) {
        this.put(SERP_LAYOUT_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }
}
