package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.IncomeGradeAdjustmentGet;
import com.yandex.direct.api.v5.general.IncomeGradeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class IncomeGradeAdjustmentGetMap extends ModelBeanMap<IncomeGradeAdjustmentGetMap> {
    public static final String BID_MODIFIER = "bidModifier";
    public static final String GRADE = "grade";

    public IncomeGradeAdjustmentGetMap() {
        super();
        setBean(new IncomeGradeAdjustmentGet());
    }

    public IncomeGradeAdjustmentGetMap(IncomeGradeAdjustmentGetMap incomeGradeAdjustmentGetMap) {
        super();
        setBean(incomeGradeAdjustmentGetMap);
    }

    public IncomeGradeAdjustmentGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public IncomeGradeAdjustmentGetMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public IncomeGradeAdjustmentGetMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public IncomeGradeAdjustmentGetMap withGrade(IncomeGradeEnum gradeEnum) {
        this.put(GRADE, gradeEnum);
        return this;
    }

    public IncomeGradeAdjustmentGetMap withDefaultGrade() {
        this.put(GRADE, IncomeGradeEnum.VERY_HIGH);
        return this;
    }
}
