package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.IncomeGradeAdjustmentAdd;
import com.yandex.direct.api.v5.general.IncomeGradeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class IncomeGradeAdjustmentMap extends ModelBeanMap<IncomeGradeAdjustmentMap> {
    public static final String BID_MODIFIER = "bidModifier";
    public static final String GRADE = "grade";

    public IncomeGradeAdjustmentMap() {
        super();
        setBean(new IncomeGradeAdjustmentAdd());
    }

    public IncomeGradeAdjustmentMap(IncomeGradeAdjustmentMap incomeGradeAdjustmentMap) {
        super();
        setBean(incomeGradeAdjustmentMap);
    }

    public IncomeGradeAdjustmentMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public IncomeGradeAdjustmentMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public IncomeGradeAdjustmentMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public IncomeGradeAdjustmentMap withGrade(IncomeGradeEnum gradeEnum) {
        this.put(GRADE, gradeEnum);
        return this;
    }

    public IncomeGradeAdjustmentMap withDefaultGrade() {
        this.put(GRADE, IncomeGradeEnum.VERY_HIGH);
        return this;
    }
}
