package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

public final class JavaOrPerlToggleExpectedResult {
    private ToggleExpectedResult javaResult;
    private ToggleExpectedResult perlResult;

    private JavaOrPerlToggleExpectedResult(ToggleExpectedResult javaResult, ToggleExpectedResult perlResult) {
        this.javaResult = javaResult;
        this.perlResult = perlResult;
    }

    public static JavaOrPerlToggleExpectedResult java(ToggleExpectedResult javaResult) {
        return new JavaOrPerlToggleExpectedResult(javaResult, null);
    }

    public static JavaOrPerlToggleExpectedResult both(ToggleExpectedResult result) {
        return new JavaOrPerlToggleExpectedResult(result, result);
    }

    public ToggleExpectedResult getJavaResult() {
        return javaResult;
    }

    public ToggleExpectedResult getPerlResult() {
        return perlResult;
    }

    public JavaOrPerlToggleExpectedResult perl(ToggleExpectedResult perlResult) {
        this.perlResult = perlResult;
        return this;
    }
}
