package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentGet;
import com.yandex.direct.api.v5.bidmodifiers.ObjectFactory;
import com.yandex.direct.api.v5.bidmodifiers.OperatingSystemTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 13.07.15.
 */
public class MobileAdjustmentGetMap extends ModelBeanMap<MobileAdjustmentGetMap> {
    public static final String BID_MODIFIER = "bidModifier";
    public static final String OPERATING_SYSTEM_TYPE = "operatingSystemType";

    public MobileAdjustmentGetMap() {
        this(new MobileAdjustmentGet());
    }

    public MobileAdjustmentGetMap(MobileAdjustmentGet mobileAdjustment) {
        super();
        setBean(mobileAdjustment);
    }

    public MobileAdjustmentGetMap defaultMobileAdjustment() {
        this.clear();
        return withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public MobileAdjustmentGetMap withBidModifier(Integer bidModifier) {
        return put(BID_MODIFIER, bidModifier);
    }

    public MobileAdjustmentGetMap withOperatingSystemType(OperatingSystemTypeEnum operatingSystemType) {
        JAXBElement<OperatingSystemTypeEnum> jaxbElement =
                new ObjectFactory().createMobileAdjustmentGetOperatingSystemType(operatingSystemType);
        return put(OPERATING_SYSTEM_TYPE, jaxbElement);
    }
}
