package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentAdd;
import com.yandex.direct.api.v5.bidmodifiers.OperatingSystemTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 13.07.15.
 */
public class MobileAdjustmentMap extends ModelBeanMap<MobileAdjustmentMap> {
    public static final String BID_MODIFIER = "bidModifier";
    public static final String OPERATING_SYSTEM_TYPE = "operatingSystemType";

    public static final int MOBILE_ADJUSTMENT_MAX = 1300;
    public static final int MOBILE_ADJUSTMENT_MIN = 50;
    public static final int MOBILE_ADJUSTMENT_ABSOLUTE_MIN = 0;

    public MobileAdjustmentMap() {
        this(new MobileAdjustmentAdd());
    }

    public MobileAdjustmentMap(MobileAdjustmentAdd mobileAdjustment) {
        super();
        setBean(mobileAdjustment);
    }

    public MobileAdjustmentMap defaultMobileAdjustment() {
        this.clear();
        return this.withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public MobileAdjustmentMap defaultMobileIosAdjustment() {
        return defaultMobileAdjustment().withOperatingSystemType(OperatingSystemTypeEnum.IOS);
    }

    public MobileAdjustmentMap withBidModifier(Integer bidModifier) {
        return put(BID_MODIFIER, bidModifier);
    }

    public MobileAdjustmentMap withOperatingSystemType(OperatingSystemTypeEnum operatingSystemType) {
        return put(OPERATING_SYSTEM_TYPE, operatingSystemType);
    }
}
