package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.RegionalAdjustmentGet;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 15.03.17.
 */
public class RegionalAdjustmentGetMap extends ModelBeanMap<RegionalAdjustmentGetMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String REGION_ID = "regionId";

    public RegionalAdjustmentGetMap() {
        super();
        setBean(new RegionalAdjustmentGet());
    }

    public RegionalAdjustmentGetMap(RegionalAdjustmentGet regionalAdjustment) {
        super();
        setBean(regionalAdjustment);
    }

    public RegionalAdjustmentGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RegionalAdjustmentGetMap defaultRegionalAdjustment() {
        this.clear();
        return this.withDefaultBidModifier();
    }

    public RegionalAdjustmentGetMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public RegionalAdjustmentGetMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public RegionalAdjustmentGetMap withRegionId(Long regionId) {
        this.put(REGION_ID, regionId);
        return this;
    }

    public RegionalAdjustmentGetMap withRegionId(int regionId) {
        return withRegionId(new Long(regionId));
    }

}
