package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.RegionalAdjustmentAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;

/**
 * Created by ginger on 15.03.17.
 */
public class RegionalAdjustmentMap extends ModelBeanMap<RegionalAdjustmentMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String REGION_ID = "regionId";

    //кампании с типом text и web_mobile_app
    public static final int REGIONAL_ADJUSTMENT_MAX = 1300;
    public static final int REGIONAL_ADJUSTMENT_MIN = 10;
    public static final Integer DEFAULT_REGION_ID = RegionIDValues.SPB.getId();

    public RegionalAdjustmentMap() {
        super();
        setBean(new RegionalAdjustmentAdd());
    }

    public RegionalAdjustmentMap(RegionalAdjustmentAdd regionalAdjustment) {
        super();
        setBean(regionalAdjustment);
    }

    public RegionalAdjustmentMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RegionalAdjustmentMap defaultRegionalAdjustment() {
        this.clear();
        return this
                .withDefaultBidModifier()
                .withDefaultRegionId();
    }

    public RegionalAdjustmentMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public RegionalAdjustmentMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public RegionalAdjustmentMap withRegionId(Long regionId) {
        this.put(REGION_ID, regionId);
        return this;
    }

    public RegionalAdjustmentMap withDefaultRegionId() {
        this.put(REGION_ID, DEFAULT_REGION_ID);
        return this;
    }

    public RegionalAdjustmentMap withRegionId(int regionId) {
        return withRegionId(new Long(regionId));
    }

}
