package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.RetargetingAdjustmentAdd;
import com.yandex.direct.api.v5.bidmodifiers.RetargetingAdjustmentGet;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 13.07.15.
 */
public class RetargetingAdjustmentGetMap extends ModelBeanMap<RetargetingAdjustmentGetMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String RETARGETING_CONDITION_ID = "retargetingConditionId";

    public RetargetingAdjustmentGetMap() {
        super();
        setBean(new RetargetingAdjustmentGet());
    }

    public RetargetingAdjustmentGetMap(RetargetingAdjustmentAdd demographicsAdjustment) {
        super();
        setBean(demographicsAdjustment);
    }

    public RetargetingAdjustmentGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingAdjustmentGetMap defaultRetargetingAdjustment() {
        this.clear();
        return this.withDefaultBidModifier();
    }

    public RetargetingAdjustmentGetMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public RetargetingAdjustmentGetMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public RetargetingAdjustmentGetMap withRetargetingConditionId(Long retargetingConditionId) {
        this.put(RETARGETING_CONDITION_ID, retargetingConditionId);
        return this;
    }

    public RetargetingAdjustmentGetMap withRetargetingConditionId(int retargetingConditionId) {
        return withRetargetingConditionId(new Long(retargetingConditionId));
    }

}
