package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.RetargetingAdjustmentAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 13.07.15.
 */
public class RetargetingAdjustmentMap extends ModelBeanMap<RetargetingAdjustmentMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String RETARGETING_CONDITION_ID = "retargetingConditionId";

    //кампании с типом text и web_mobile_app
    public static final int RETARGETING_ADJUSTMENT_MAX = 1300;
    public static final int RETARGETING_ADJUSTMENT_MIN = 0;

    public RetargetingAdjustmentMap() {
        super();
        setBean(new RetargetingAdjustmentAdd());
    }

    public RetargetingAdjustmentMap(RetargetingAdjustmentAdd demographicsAdjustment) {
        super();
        setBean(demographicsAdjustment);
    }

    public RetargetingAdjustmentMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingAdjustmentMap defaultRetargetingAdjustment() {
        this.clear();
        return this.withDefaultBidModifier();
    }

    public RetargetingAdjustmentMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public RetargetingAdjustmentMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public RetargetingAdjustmentMap withRetargetingConditionId(Long retargetingConditionId) {
        this.put(RETARGETING_CONDITION_ID, retargetingConditionId);
        return this;
    }

    public RetargetingAdjustmentMap withRetargetingConditionId(int retargetingConditionId) {
        return withRetargetingConditionId(new Long(retargetingConditionId));
    }

}
