package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.SerpLayoutAdjustmentGet;
import com.yandex.direct.api.v5.general.SerpLayoutEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SerpLayoutAdjustmentGetMap extends ModelBeanMap<SerpLayoutAdjustmentGetMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String SERP_LAYOUT = "serpLayout";

    public SerpLayoutAdjustmentGetMap() {
        super();
        setBean(new SerpLayoutAdjustmentGet());
    }

    public SerpLayoutAdjustmentGetMap(SerpLayoutAdjustmentGet serpLayoutAdjustment) {
        super();
        setBean(serpLayoutAdjustment);
    }

    public SerpLayoutAdjustmentGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SerpLayoutAdjustmentGetMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public SerpLayoutAdjustmentGetMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public SerpLayoutAdjustmentGetMap withSerpLayout(SerpLayoutEnum serpLayout) {
        this.put(SERP_LAYOUT, serpLayout);
        return this;
    }

    /**
     * For negative cases usage
     */
    public SerpLayoutAdjustmentGetMap withSerpLayout(String serpLayout) {
        this.put(SERP_LAYOUT, serpLayout);
        return this;
    }
}
