package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.SerpLayoutAdjustmentAdd;
import com.yandex.direct.api.v5.general.SerpLayoutEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SerpLayoutAdjustmentMap extends ModelBeanMap<SerpLayoutAdjustmentMap> {

    public static final String BID_MODIFIER = "bidModifier";
    public static final String SERP_LAYOUT = "serpLayout";

    public static final int SERP_LAYOUT_ADJUSTMENT_MAX = 1300;
    public static final int SERP_LAYOUT_ADJUSTMENT_MIN = 100;

    public SerpLayoutAdjustmentMap() {
        super();
        setBean(new SerpLayoutAdjustmentAdd());
    }

    public SerpLayoutAdjustmentMap(SerpLayoutAdjustmentAdd serpLayoutAdjustment) {
        super();
        setBean(serpLayoutAdjustment);
    }

    public SerpLayoutAdjustmentMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SerpLayoutAdjustmentMap defaultSerpLayoutAdjustment() {
        this.clear();
        return this.withSerpLayout(SerpLayoutEnum.ALONE)
                .withDefaultBidModifier();
    }

    public SerpLayoutAdjustmentMap withDefaultBidModifier() {
        this.put(BID_MODIFIER, BidModifierAddMap.DEFAULT_BID_MODIFIER);
        return this;
    }

    public SerpLayoutAdjustmentMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

    public SerpLayoutAdjustmentMap withSerpLayout(SerpLayoutEnum serpLayout) {
        this.put(SERP_LAYOUT, serpLayout);
        return this;
    }

    /**
     * For negative cases usage
     */
    public SerpLayoutAdjustmentMap withSerpLayout(String serpLayout) {
        this.put(SERP_LAYOUT, serpLayout);
        return this;
    }

}
