package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.SetRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by chicos on 31.07.15.
 */
public class SetRequestMap extends ModelBeanMap<SetRequestMap> {

    public static final String BID_MODIFIERS = "bidModifiers";

    public static final int BID_MODIFIERS_IN_REQUEST_LIMIT = 1000;

    public SetRequestMap() {
        super();
        setBean(new SetRequest());
    }

    public SetRequestMap(SetRequest setRequest) {
        super();
        setBean(setRequest);
    }

    public SetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SetRequestMap withBidModifiers(BidModifierSetMap... bidModifiers) {
        this.put(BID_MODIFIERS, (bidModifiers == null) ? null : convert(bidModifiers, new BeanMapToBeanConverter()));
        return this;
    }
}
