package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.SmartTvAdjustmentAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartTvAdjustmentMap extends ModelBeanMap<SmartTvAdjustmentMap> {
    public static final String BID_MODIFIER = "bidModifier";
    public static final int SMARTTV_ADJUSTMENT_ABSOLUTE_MIN = 0;


    public SmartTvAdjustmentMap() {
        this(new SmartTvAdjustmentAdd());
    }

    public SmartTvAdjustmentMap(SmartTvAdjustmentAdd smartTvAdjustment) {
        super();
        setBean(smartTvAdjustment);
    }
    public SmartTvAdjustmentMap defaultSmartTvAdjustment() {
        this.clear();
        return withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public SmartTvAdjustmentMap withBidModifier(Integer bidModifier) {
        return put(BID_MODIFIER, bidModifier);
    }
}
