package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.ToggleRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by chicos on 31.07.15.
 */
public class ToggleRequestMap extends ModelBeanMap<ToggleRequestMap> {

    public static final String BID_MODIFIER_TOGGLE_ITEMS = "bidModifierToggleItems";

    public static final int BID_MODIFIERS_IN_REQUEST_LIMIT = 1000;

    public ToggleRequestMap() {
        super();
        setBean(new ToggleRequest());
    }

    public ToggleRequestMap(ToggleRequest toggleRequest) {
        super();
        setBean(toggleRequest);
    }

    public ToggleRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ToggleRequestMap withBidModifierToggleItems(BidModifierToggleMap... bidModifierToggleItems) {
        this.put(BID_MODIFIER_TOGGLE_ITEMS, (bidModifierToggleItems == null) ?
                null :
                convert(bidModifierToggleItems, new BeanMapToBeanConverter()));
        return this;
    }
}
