package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.bidmodifiers.ToggleResult;

import ru.yandex.autotests.directapi.model.api5.general.ActionResultBaseMap;


/**
 * Created by chicos on 31.07.15.
 */
public class ToggleResultMap extends ActionResultBaseMap {

    public static final String CAMPAIGN_ID = "campaignId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String TYPE = "type";

    public ToggleResultMap() {
        super();
        setBean(new ToggleResult());
    }

    public ToggleResultMap(ToggleResult actionResult) {
        super();
        setBean(actionResult);
    }

    public ToggleResultMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ToggleResultMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public ToggleResultMap withAdGroupId(Long groupId) {
        this.put(AD_GROUP_ID, groupId);
        return this;
    }

    public ToggleResultMap withType(BidModifierToggleTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public ToggleResultMap withType(String type) {
        this.put(TYPE, type);
        return this;
    }
}
