package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.VideoAdjustmentAdd;
import com.yandex.direct.api.v5.bidmodifiers.VideoAdjustmentGet;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by liosha on 16.01.2018.
 */
public class VideoAdjustmentGetMap extends ModelBeanMap<VideoAdjustmentGetMap> {

    public static final String BID_MODIFIER = "bidModifier";

    public VideoAdjustmentGetMap() {
        super();
        setBean(new VideoAdjustmentGet());
    }

    public VideoAdjustmentGetMap(VideoAdjustmentAdd videoAdjustment) {
        super();
        setBean(videoAdjustment);
    }

    public VideoAdjustmentGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VideoAdjustmentGetMap defaultVideoAdjustment() {
        this.clear();
        return this.withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public VideoAdjustmentGetMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }

}
