package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.VideoAdjustmentAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by liosha on 16.01.2018.
 */
public class VideoAdjustmentMap extends ModelBeanMap<VideoAdjustmentMap> {
    public static final String BID_MODIFIER = "bidModifier";

    public static final int VIDEO_ADJUSTMENT_MAX = 1300;
    public static final int VIDEO_ADJUSTMENT_MIN = 50;

    public VideoAdjustmentMap() {
        super();
        setBean(new VideoAdjustmentAdd());
    }

    public VideoAdjustmentMap(VideoAdjustmentAdd videoAdjustment) {
        super();
        setBean(videoAdjustment);
    }

    public VideoAdjustmentMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VideoAdjustmentMap defaultVideoAdjustment() {
        this.clear();
        return this.withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER);
    }

    public VideoAdjustmentMap withBidModifier(Integer bidModifier) {
        this.put(BID_MODIFIER, bidModifier);
        return this;
    }
}