package ru.yandex.autotests.directapi.model.api5.bids;

import com.yandex.direct.api.v5.bids.AuctionBidItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 10.08.15.
 */
public class AuctionBidItemMap<T> extends ModelBeanMap<AuctionBidItemMap> {

    private static final String AUCTION_BID_ITEM = "AuctionBidItem";
    public static final String PRICE = "price";
    public static final String BID = "bid";
    public static final String POSITION = "position";


    public AuctionBidItemMap() {
        super();
        setBean(new AuctionBidItem());
    }

    public AuctionBidItemMap(AuctionBidItem auctionBidItem) {
        super();
        setBean(auctionBidItem);
    }

    public AuctionBidItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AuctionBidItemMap withPrice(Long price) {
        this.put((PRICE), price);
        return this;
    }

    public AuctionBidItemMap withBid(Long bid) {
        this.put((BID), bid);
        return this;
    }

    public AuctionBidItemMap withPosition(String position) {
        this.put((POSITION), position);
        return this;
    }
}
